% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05a_probabilistic_analysis_functions.R
\name{generate_psa_params}
\alias{generate_psa_params}
\title{Generate PSA dataset of CEA parameters}
\usage{
generate_psa_params(l_params_all, seed = 20210202)
}
\arguments{
\item{l_params_all}{List with all parameters of cost-effectiveness model.}

\item{seed}{Seed for reproducibility of Monte Carlo sampling.}
}
\value{
A data frame with 18 columns of parameters for PSA. Each row is a parameter
set sampled from distributions that characterize their uncertainty
}
\description{
\code{generate_psa_params} generates PSA input dataset by sampling decision
model parameters from their distributions. The sample of the calibrated
parameters is a draw from their posterior distribution obtained with the
IMIS algorithm.
}
\examples{
generate_psa_params(l_params_all = load_all_params())
}
