require(here)
source(here::here("3_Functions", "utility", "age_related.R"))

# When the tables are brought in from Excel they are in a bad way...
.i <- list(
  R_table_ageadjust_util_female = data.frame(
    Comp...Prob = c(NA, "Comp. 1", NA, NA, "Comp. 2", NA, NA, "Comp. 3", NA, NA, "Probability", "Comp. 1", "Probability", "Comp. 2", NA, NA, NA),
    Parameter.name = c(NA, "Age/10", "(Age/10)^2", "intercept", "Age/10", "(Age/10)^2", "intercept", "Age/10", "(Age/10)^2", "intercept", "Age/10", "intercept", "Age/10", "intercept", "ln(sigma 1)", "ln(sigma 2)", "ln(sigma 3)"),
    Females.Coefficient = c(NA, -0.0774, 0.0064, 0.299, -0.0147, -3e-04, 0.8708, 0.2043, -0.0241, 1.1659, 0.4028, -4.4767, 0.1937, -1.3549, 0.1282, 0.0831, 0.523),
    Comp..1 = c("Age/10", "0.00181392505720311", "-0.000142821693113575", "-0.0055479120716095", "-8.40757439459012E-005", "7.68974788428647E-006", "0.000190677927101904", "7.6302791281555E-005", "2.68779546956997E-006", "-0.00188544592603937", "0.000587152824726099", "-0.00481411649614175", "8.6460875110737E-005", "-0.00166767866848402", "-0.00156514893635572", "-0.000663410325683143", "-0.000972530455969163"),
    X5 = c("(Age/10)^2", "-0.000142821693113575", "1.16455508725469E-005", "0.000418371324371852", "7.82095798774855E-006", "-7.12226266273064E-007", "-1.80062162214054E-005", "-2.26878716411079E-005", "1.48733633962288E-006", "0.000186201780049869", "-3.19362611056718E-005", "0.000268200605768575", "-3.59817626829164E-006", "0.000107750120010565", "0.000100070484970427", "4.96783571225564E-005", "9.3754534593677E-005"),
    X6 = c("intercept", "-0.0055479120716095", "0.000418371324371852", "0.017929999114245", "0.000204381130695266", "-1.88905888936587E-005", "-0.000448400461518393", "0.000726813592080134", "-0.000105482348999307", "0.00392086064903466", "-0.00250180036404139", "0.020339890843711", "-0.000422003990381206", "0.00652323274561575", "0.00591937681079903", "0.00229152315171725", "0.00243235134805328"),
    Comp..2 = c("Age/10", "-8.40757439459012E-005", "7.82095798774855E-006", "0.000204381130695266", "0.000129215443937247", "-1.17793555804664E-005", "-0.000304065105412462", "-0.000475467875705631", "4.19123774206381E-005", "0.00230435810147678", "0.000142215345506761", "-0.000800368532530154", "1.28042740613655E-005", "0.000599852244867536", "-0.00016384837041777", "0.000332775202597476", "0.00137953646923537"),
    X8 = c("(Age/10)^2", "7.68974788428647E-006", "-7.12226266273064E-007", "-1.88905888936587E-005", "-1.17793555804664E-005", "1.10760266422821E-006", "2.63878432142222E-005", "4.28812634826882E-005", "-3.85817932365746E-006", "-0.000207192172603296", "-1.38120152179962E-005", "7.61484851195201E-005", "-3.80182641717489E-007", "-6.40549916222688E-005", "1.42176634583524E-005", "-3.31596324456354E-005", "-0.000126872002764403"),
    X9 = c("intercept", "0.000190677927101904", "-1.80062162214054E-005", "-0.000448400461518393", "-0.000304065105412462", "2.63878432142222E-005", "0.000781154174073528", "0.00114152107318473", "-9.72997109845831E-005", "-0.00550983733742592", "-0.000291616289476088", "0.00170190898250888", "-6.85206409897883E-005", "-0.000888429870817027", "0.000408287149410796", "-0.00061462673994418", "-0.00312609418508427"),
    Comp..3 = c("Age/10", "7.6302791281555E-005", "-2.26878716411079E-005", "0.000726813592080134", "-0.000475467875705631", "4.28812634826882E-005", "0.00114152107318473", "0.00806160262858", "-0.000764694318342423", "-0.0208673418054048", "-0.00158080633547213", "0.0122473970122137", "-4.41025130039184E-006", "-8.71455602468233E-005", "0.00258293728957508", "0.000116466474103241", "-0.00505463894217601"),
    X11 = c("(Age/10)^2", "2.68779546956997E-006", "1.48733633962288E-006", "-0.000105482348999307", "4.19123774206381E-005", "-3.85817932365746E-006", "-9.72997109845831E-005", "-0.000764694318342423", "7.5493603505479E-005", "0.00181159033077672", "0.000185660167714886", "-0.00136422743399523", "2.55924927356128E-005", "-0.000158988348362669", "-0.000256232307785368", "-2.4374052739607E-005", "0.000390936271290489"),
    X12 = c("intercept", "-0.00188544592603937", "0.000186201780049869", "0.00392086064903466", "0.00230435810147678", "-0.000207192172603296", "-0.00550983733742592", "-0.0208673418054048", "0.00181159033077672", "0.0923336511771454", "0.00552376527983363", "-0.0361265561727065", "-0.000674465305138563", "0.023043690461186", "-0.00789090909426419", "0.00812722271087936", "0.0508836994965293"),
    Probability = c("Age/10", "0.000587152824726099", "-3.19362611056718E-005", "-0.00250180036404139", "0.000142215345506761", "-1.38120152179962E-005", "-0.000291616289476088", "-0.00158080633547213", "0.000185660167714886", "0.00552376527983363", "0.00374720476972074", "-0.0235409197342492", "0.000813711359859942", "-0.00315976776505383", "-0.00278988754751826", "0.000371359871490182", "0.0049723966315152"),
    Comp..1.1 = c("intercept", "-0.00481411649614175", "0.000268200605768575", "0.020339890843711", "-0.000800368532530154", "7.61484851195201E-005", "0.00170190898250888", "0.0122473970122137", "-0.00136422743399523", "-0.0361265561727065", "-0.0235409197342492", "0.160964976476367", "-0.00456257092300774", "0.0235248148927389", "0.0206457263706382", "0.000765815120668832", "-0.0295522138203499"),
    Probability.1 = c("Age/10", "8.6460875110737E-005", "-3.59817626829164E-006", "-0.000422003990381206", "1.28042740613655E-005", "-3.80182641717489E-007", "-6.85206409897883E-005", "-4.41025130039184E-006", "2.55924927356128E-005", "-0.000674465305138563", "0.000813711359859942", "-0.00456257092300774", "0.00119093744451877", "-0.00644165502249595", "-0.000590416579476868", "-8.86112282562339E-005", "0.000251477628529736"),
    Comp..2.1 = c("intercept", "-0.00166767866848402", "0.000107750120010565", "0.00652323274561575", "0.000599852244867536", "-6.40549916222688E-005", "-0.000888429870817027", "-8.71455602468233E-005", "-0.000158988348362669", "0.023043690461186", "-0.00315976776505383", "0.0235248148927389", "-0.00644165502249595", "0.0504179889713566", "0.00320982232761227", "0.00753199473767298", "0.0180944191956392"),
    ln.sigma. = c("ln(sigma 1)", "-0.00156514893635572", "0.000100070484970427", "0.00591937681079903", "-0.00016384837041777", "1.42176634583524E-005", "0.000408287149410796", "0.00258293728957508", "-0.000256232307785368", "-0.00789090909426419", "-0.00278988754751826", "0.0206457263706382", "-0.000590416579476868", "0.00320982232761227", "0.00705433604345044", "0.000337621060753791", "-0.00545270993573478"),
    X18 = c("ln(sigma 2)", "-0.000663410325683143", "4.96783571225564E-005", "0.00229152315171725", "0.000332775202597476", "-3.31596324456354E-005", "-0.00061462673994418", "0.000116466474103241", "-2.4374052739607E-005", "0.00812722271087936", "0.000371359871490182", "0.000765815120668832", "-8.86112282562339E-005", "0.00753199473767298", "0.000337621060753791", "0.00440694744795823", "0.00821659420933332"),
    X19 = c("ln(sigma 3)", "-0.000972530455969163", "9.3754534593677E-005", "0.00243235134805328", "0.00137953646923537", "-0.000126872002764403", "-0.00312609418508427", "-0.00505463894217601", "0.000390936271290489", "0.0508836994965293", "0.0049723966315152", "-0.0295522138203499", "0.000251477628529736", "0.0180944191956392", "-0.00545270993573478", "0.00821659420933332", "0.0460540905247068")
  ),
  R_table_ageadjust_util_male = data.frame(
    Comp...Prob = c(NA, "Comp. 1", NA, NA, "Comp. 2", NA, NA, "Comp. 3", NA, NA, "Probability", "Comp. 1", "Probability", "Comp. 2", NA, NA, NA),
    Parameter.name = c(NA, "Age/10", "(Age/10)^2", "intercept", "Age/10", "(Age/10)^2", "intercept", "Age/10", "(Age/10)^2", "intercept", "Age/10", "intercept", "Age/10", "intercept", "ln(sigma 1)", "ln(sigma 2)", "ln(sigma 3)"),
    Males.Coefficient = c(NA, -0.1609, 0.0129, 0.566, -0.008, -7e-04, 0.8502, -0.0316, -0.0051, 1.8194, 0.2804, -4.3366, 0.1445, -1.5277, 0.114, 0.0694, 0.5402),
    Comp..1 = c("Age/10", "0.00180805718467376", "-0.000155394881440412", "-0.00469913686058501", "-2.04952315731803E-005", "1.76923239057346E-006", "4.13832367350342E-005", "0.000724985445230411", "-4.29945708400744E-005", "-0.00419163322868301", "0.000243660127142515", "0.000556416440293352", "8.68801453301919E-006", "-0.000753361254277279", "0.00140970939608021", "-0.00030592183178308", "-0.00246332628313912"),
    X5 = c("(Age/10)^2", "-0.000155394881440412", "1.37293340332065E-005", "0.000389989054876887", "1.15986392145827E-006", "-9.6203795448618E-008", "-2.28470786199977E-006", "-5.648506654603E-005", "3.28653129116847E-006", "0.000331297591343349", "-1.73125504820459E-005", "-6.93863510738457E-005", "3.58862037847825E-007", "4.95701869200483E-005", "-0.000109852868343991", "1.86262054382121E-005", "0.000196433717937509"),
    X6 = c("intercept", "-0.00469913686058501", "0.000389989054876887", "0.0129220764505025", "0.00011009363782216", "-1.04025906841095E-005", "-0.00021221368996537", "-0.00235626079994355", "0.000145555525358209", "0.0139005433706322", "-0.000666785188679418", "-0.000974292019637207", "5.06833797379128E-005", "0.00285419281192027", "-0.00431979774938225", "0.00177163662118351", "0.0082152338918358"),
    Comp..2 = c("Age/10", "-2.04952315731803E-005", "1.15986392145827E-006", "0.00011009363782216", "0.000153983966039955", "-1.36488145264166E-005", "-0.000384174295666304", "-0.000678878300109977", "5.38490308619695E-005", "0.00303714645783587", "9.2890859246708E-005", "-0.000416866418886413", "0.000135744870622466", "0.000170340333384842", "-0.000257581188220602", "0.000710963391255698", "0.00124117311711967"),
    X8 = c("(Age/10)^2", "1.76923239057346E-006", "-9.6203795448618E-008", "-1.04025906841095E-005", "-1.36488145264166E-005", "1.24910273084314E-006", "3.26431593531585E-005", "6.44394089603446E-005", "-5.16220406451199E-006", "-0.000293809272506211", "-9.37628800183464E-006", "3.99645405636231E-005", "-1.1841706886419E-005", "-3.17130333909983E-005", "2.3729404294288E-005", "-7.5703498485862E-005", "-0.000124608151214571"),
    X9 = c("intercept", "4.13832367350342E-005", "-2.28470786199977E-006", "-0.00021221368996537", "-0.000384174295666304", "3.26431593531585E-005", "0.00101958664039823", "0.00152197651396501", "-0.000119747171492014", "-0.00654045239171073", "-0.000201913638339085", "0.000919351639672103", "-0.000354448771901043", "0.000311668000907189", "0.000558020538151863", "-0.00125776941422995", "-0.00245283652375875"),
    Comp..3 = c("Age/10", "0.000724985445230411", "-5.648506654603E-005", "-0.00235626079994355", "-0.000678878300109977", "6.44394089603446E-005", "0.00152197651396501", "0.0113858914551752", "-0.000931927238570606", "-0.0457277118567312", "-0.000470852960992384", "0.0045059996437656", "-0.00038789136821903", "-0.00860299633420163", "0.00460629229305843", "-0.00768312816822898", "-0.0173519590055757"),
    X11 = c("(Age/10)^2", "-4.29945708400744E-005", "3.28653129116847E-006", "0.000145555525358209", "5.38490308619695E-005", "-5.16220406451199E-006", "-0.000119747171492014", "-0.000931927238570606", "7.97305909426276E-005", "0.00348314479613714", "6.68265629615078E-005", "-0.000482915286976749", "4.44177723214262E-005", "0.000549945323083734", "-0.000321384872390157", "0.000573328600141507", "0.00123904583267989"),
    X12 = c("intercept", "-0.00419163322868301", "0.000331297591343349", "0.0139005433706322", "0.00303714645783587", "-0.000293809272506211", "-0.00654045239171073", "-0.0457277118567312", "0.00348314479613714", "0.220920263819935", "0.00262782787645511", "-0.0229728839249657", "0.00227885855505096", "0.0516945030490172", "-0.02466047496201", "0.0451087733515744", "0.102106928289112"),
    Probability = c("Age/10", "0.000243660127142515", "-1.73125504820459E-005", "-0.000666785188679418", "9.2890859246708E-005", "-9.37628800183464E-006", "-0.000201913638339085", "-0.000470852960992384", "6.68265629615078E-005", "0.00262782787645511", "0.00375620898511979", "-0.0205640680849767", "0.00098761301789045", "-0.00319365084944945", "7.82811452991396E-007", "0.00129025173814629", "0.00243439635247922"),
    Comp..1.1 = c("intercept", "0.000556416440293352", "-6.93863510738457E-005", "-0.000974292019637207", "-0.000416866418886413", "3.99645405636231E-005", "0.000919351639672103", "0.0045059996437656", "-0.000482915286976749", "-0.0229728839249657", "-0.0205640680849767", "0.135277707719853", "-0.00520169978644947", "0.0216700313230661", "0.00736586742092584", "-0.00292680780215841", "-0.0205436877294718"),
    Probability.1 = c("Age/10", "8.68801453301919E-006", "3.58862037847825E-007", "5.06833797379128E-005", "0.000135744870622466", "-1.1841706886419E-005", "-0.000354448771901043", "-0.00038789136821903", "4.44177723214262E-005", "0.00227885855505096", "0.00098761301789045", "-0.00520169978644947", "0.00128577080041762", "-0.00566979482005049", "-0.000345039831748517", "0.000810459882349813", "0.00183133956149149"),
    Comp..2.1 = c("intercept", "-0.000753361254277279", "4.95701869200483E-005", "0.00285419281192027", "0.000170340333384842", "-3.17130333909983E-005", "0.000311668000907189", "-0.00860299633420163", "0.000549945323083734", "0.0516945030490172", "-0.00319365084944945", "0.0216700313230661", "-0.00566979482005049", "0.0543623781150663", "-0.00309975120152338", "0.0166892820314486", "0.0244096288469085"),
    ln.sigma. = c("ln(sigma 1)", "0.00140970939608021", "-0.000109852868343991", "-0.00431979774938225", "-0.000257581188220602", "2.3729404294288E-005", "0.000558020538151863", "0.00460629229305843", "-0.000321384872390157", "-0.02466047496201", "7.82811452991396E-007", "0.00736586742092584", "-0.000345039831748517", "-0.00309975120152338", "0.0132715906497832", "-0.0029432939805352", "-0.0145268213896526"),
    X18 = c("ln(sigma 2)", "-0.00030592183178308", "1.86262054382121E-005", "0.00177163662118351", "0.000710963391255698", "-7.5703498485862E-005", "-0.00125776941422995", "-0.00768312816822898", "0.000573328600141507", "0.0451087733515744", "0.00129025173814629", "-0.00292680780215841", "0.000810459882349813", "0.0166892820314486", "-0.0029432939805352", "0.0172254773943738", "0.0235021382458683"),
    X19 = c("ln(sigma 3)", "-0.00246332628313912", "0.000196433717937509", "0.0082152338918358", "0.00124117311711967", "-0.000124608151214571", "-0.00245283652375875", "-0.0173519590055757", "0.00123904583267989", "0.102106928289112", "0.00243439635247922", "-0.0205436877294718", "0.00183133956149149", "0.0244096288469085", "-0.0145268213896526", "0.0235021382458683", "0.0584012933799599")
  )
)

testthat::test_that("it calculates mean utilities correctly", {
  
  covariates <- data.frame(
    age10         = as.numeric(16:101) / 10,
    age10sq       = as.numeric(16:101) ^ 2 / 100,
    `(Intercept)` = 1.0
  )
  
  l_coefficients <- list(
    c(age10 = -0.0774, age10sq =  0.0064, `(Intercept)` = 0.2990),
    c(age10 = -0.0147, age10sq = -0.0003, `(Intercept)` = 0.8708),
    c(age10 =  0.2043, age10sq = -0.0241, `(Intercept)` = 1.1659)
  )
  
  sigma <- c(0.1282, 0.0831, 0.523)
  
  l_mix_coef <- list(
    c(age10 = 0.4028, age10sq = 0.0, `(Intercept)` = -4.4767),
    c(age10 = 0.1937, age10sq = 0.0, `(Intercept)` = -1.3549)
  )
  
  u_mean_female <- utility_mixture(covariates, l_coefficients, sigma, l_mix_coef, type = "mean")
  u_mean_female <- unname(u_mean_female)
  
  target_u_female <- c(
    0.9117,0.9122,0.9126,0.9127,0.9127,0.9126,0.9122,0.9118,0.9112,0.9105,
    0.9096,0.9087,0.9076,0.9064,0.9051,0.9037,0.9022,0.9006,0.8989,0.8971,
    0.8952,0.8932,0.8912,0.8890,0.8868,0.8844,0.8820,0.8795,0.8769,0.8743,
    0.8715,0.8687,0.8658,0.8628,0.8598,0.8566,0.8534,0.8501,0.8467,0.8432,
    0.8397,0.8361,0.8324,0.8286,0.8247,0.8207,0.8167,0.8126,0.8083,0.8040,
    0.7996,0.7952,0.7906,0.7859,0.7812,0.7763,0.7714,0.7663,0.7612,0.7559,
    0.7506,0.7452,0.7396,0.7340,0.7282,0.7224,0.7164,0.7103,0.7042,0.6979,
    0.6915,0.6850,0.6784,0.6717,0.6649,0.6580,0.6510,0.6439,0.6367,0.6295,
    0.6222,0.6147,0.6073,0.5998,0.5922,0.5846
  )
  
  expect_equal(u_mean_female, target_u_female, tolerance = 1e-4)
  
})


testthat::test_that("it extracts from `i` and calculates across ages", {
  
  target_u_female <- c(
    0.9117,0.9122,0.9126,0.9127,0.9127,0.9126,0.9122,0.9118,0.9112,0.9105,
    0.9096,0.9087,0.9076,0.9064,0.9051,0.9037,0.9022,0.9006,0.8989,0.8971,
    0.8952,0.8932,0.8912,0.8890,0.8868,0.8844,0.8820,0.8795,0.8769,0.8743,
    0.8715,0.8687,0.8658,0.8628,0.8598,0.8566,0.8534,0.8501,0.8467,0.8432,
    0.8397,0.8361,0.8324,0.8286,0.8247,0.8207,0.8167,0.8126,0.8083,0.8040,
    0.7996,0.7952,0.7906,0.7859,0.7812,0.7763,0.7714,0.7663,0.7612,0.7559,
    0.7506,0.7452,0.7396,0.7340,0.7282,0.7224,0.7164,0.7103,0.7042,0.6979,
    0.6915,0.6850,0.6784,0.6717,0.6649,0.6580,0.6510,0.6439,0.6367,0.6295,
    0.6222,0.6147,0.6073,0.5998,0.5922,0.5846
  )
  
  target_u_male <- c(
    0.9446,0.9433,0.9420,0.9406,0.9392,0.9378,0.9363,0.9348,0.9332,0.9317,
    0.9300,0.9284,0.9267,0.9250,0.9232,0.9214,0.9196,0.9177,0.9158,0.9138,
    0.9118,0.9098,0.9077,0.9056,0.9034,0.9012,0.8989,0.8966,0.8943,0.8919,
    0.8895,0.8870,0.8845,0.8819,0.8793,0.8767,0.8740,0.8712,0.8684,0.8656,
    0.8627,0.8598,0.8568,0.8537,0.8507,0.8475,0.8444,0.8412,0.8379,0.8346,
    0.8312,0.8278,0.8244,0.8209,0.8174,0.8138,0.8102,0.8065,0.8028,0.7990,
    0.7952,0.7914,0.7875,0.7836,0.7796,0.7756,0.7716,0.7676,0.7635,0.7593,
    0.7552,0.7510,0.7468,0.7425,0.7383,0.7340,0.7297,0.7254,0.7211,0.7167,
    0.7124,0.7080,0.7036,0.6993,0.6949,0.6906
  )
  
  p <- add_population_utility_params(list(), .i = .i)
  
  expect_equal(utility_genpop(16:101, "female", .p = p), target_u_female, tolerance = 1e-4)
  expect_equal(utility_genpop(16:101, "male", .p = p), target_u_male, tolerance = 1e-4)
  
})

testthat::test_that("the wrapper function works for aggregate data", {
  
  p_male <- 0.6
  mean_age <- 68.0
  
  # Create a trace of condition-specific utility values
  cycle <- 1:104
  u_condition <- rep(c(0.8, 0.6), c(52, 52))
  
  # Get the output
  .p <- list(basic = list(cl_y = 1/52))
  .p <- add_population_utility_params(.p, .i = .i)
  output <- adjust_utility(age = mean_age, sex = p_male, utilities = data.frame(cycle = cycle, u = u_condition), .p = .p)
  
  # Target output calculated using Excel
  target <- c(0.8,0.799925437,0.799850851,0.799776241,0.799701608,0.799626952,0.799552273,0.79947757,0.799402844,0.799328094,0.799253321,0.799178525,0.799103706,0.799028863,0.798953996,0.798879107,0.798804194,0.798729258,0.798654298,0.798579315,0.798504309,0.79842928,0.798354227,0.79827915,0.798204051,0.798128928,0.798053781,0.797978612,0.797903418,0.797828202,0.797752962,0.797677699,0.797602413,0.797527103,0.797451769,0.797376413,0.797301033,0.797225629,0.797150202,0.797074752,0.796999279,0.796923782,0.796848262,0.796772718,0.796697151,0.79662156,0.796545946,0.796470309,0.796394649,0.796318964,0.796243257,0.796167526,0.597068829,0.597011996,0.596955145,0.596898277,0.596841391,0.596784487,0.596727566,0.596670628,0.596613672,0.596556698,0.596499707,0.596442698,0.596385672,0.596328628,0.596271566,0.596214487,0.59615739,0.596100276,0.596043145,0.595985995,0.595928828,0.595871644,0.595814442,0.595757222,0.595699985,0.59564273,0.595585458,0.595528168,0.59547086,0.595413535,0.595356192,0.595298832,0.595241454,0.595184059,0.595126646,0.595069215,0.595011767,0.594954301,0.594896817,0.594839316,0.594781798,0.594724262,0.594666708,0.594609136,0.594551547,0.594493941,0.594436316,0.594378675,0.594321015,0.594263338,0.594205644,0.594147931)
  
  testthat::expect_equal(output, target, tolerance = 1e-6)
})

testthat::test_that("the wrapper function works for patient-level data", {
  
  sex <- rep(c("female", "male"), c(3, 2))
  age <- c(63.4, 87.6, 73.5, 66.0, 81.2)
  
  # Create a trace of condition-specific utility values
  cycle <- 1:104
  u_condition <- rep(c(0.8, 0.6), c(52, 52))
  
  # Get the output
  .p <- list(basic = list(cl_y = 1/52))
  .p <- add_population_utility_params(.p, .i = .i)
  output <- adjust_utility(age = age, sex = sex, utilities = data.frame(cycle = cycle, u = u_condition), .p = .p)
  
  # Target output calculated using Excel
  target <- c(0.8,0.799906957,0.799813886,0.799720787,0.799627659,0.799534503,0.799441318,0.799348105,0.799254864,0.799161594,0.799068296,0.79897497,0.798881615,0.798788232,0.798694821,0.798601381,0.798507913,0.798414417,0.798320892,0.798227339,0.798133758,0.798040148,0.79794651,0.797852843,0.797759149,0.797665426,0.797571674,0.797477894,0.797384086,0.79729025,0.797196385,0.797102492,0.797008571,0.796914621,0.796820643,0.796726637,0.796632602,0.796538539,0.796444448,0.796350329,0.796256181,0.796162005,0.7960678,0.795973568,0.795879307,0.795785017,0.7956907,0.795596354,0.79550198,0.795407577,0.795313146,0.795218687,0.59634315,0.596272263,0.596201355,0.596130426,0.596059476,0.595988504,0.595917512,0.595846498,0.595775463,0.595704406,0.595633329,0.59556223,0.59549111,0.595419969,0.595348807,0.595277623,0.595206419,0.595135193,0.595063946,0.594992678,0.594921388,0.594850078,0.594778746,0.594707393,0.594636019,0.594564624,0.594493208,0.59442177,0.594350311,0.594278831,0.59420733,0.594135808,0.594064265,0.5939927,0.593921115,0.593849508,0.59377788,0.593706231,0.593634561,0.59356287,0.593491157,0.593419423,0.593347669,0.593275893,0.593204096,0.593132278,0.593060438,0.592988578,0.592916697,0.592844794,0.59277287,0.592700925)
  
  testthat::expect_equal(output, target, tolerance = 1e-6)
})

testthat::test_that("it adds parameters to `p`", {
  p <- list(basic = list(cl_y = 1/52))
  p <- add_population_utility_params(p, .i = .i)
  
  expected_female <- list(
    l_coefficients = list(
      c(`Age/10` = -0.0774, `(Age/10)^2` =  0.0064, intercept = 0.2990),
      c(`Age/10` = -0.0147, `(Age/10)^2` = -0.0003, intercept = 0.8708),
      c(`Age/10` =  0.2043, `(Age/10)^2` = -0.0241, intercept = 1.1659)
    ),
    l_mix_coef = list(
      c(`Age/10` = 0.4028, intercept = -4.4767),
      c(`Age/10` = 0.1937, intercept = -1.3549)
    ),
    v_sigma = c(0.1282, 0.0831, 0.523)
  )
  
  expected_male <- list(
    l_coefficients = list(
      c(`Age/10` = -0.1609, `(Age/10)^2` =  0.0129, intercept = 0.5660),
      c(`Age/10` = -0.0080, `(Age/10)^2` = -0.0007, intercept = 0.8502),
      c(`Age/10` = -0.0316, `(Age/10)^2` = -0.0051, intercept = 1.8194)
    ),
    l_mix_coef = list(
      c(`Age/10` = 0.2804, intercept = -4.3366),
      c(`Age/10` = 0.1445, intercept = -1.5277)
    ),
    v_sigma = c(0.1140, 0.0694, 0.5402)
  )
  
  testthat::expect_equal(p$util$pop_norms$female, expected_female)
  testthat::expect_equal(p$util$pop_norms$male, expected_male)
})
