% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcda.R
\name{performance_matrix}
\alias{performance_matrix}
\title{Performance matrix}
\usage{
performance_matrix(x, strategy, criteria, cri = TRUE, digits = 2,
  rownames = NULL, colnames = NULL)
}
\arguments{
\item{x}{A \code{data.frame} or \code{data.table} of simulation output 
characterizing the probability distribution of model outcomes.}

\item{strategy}{Character name of column from \code{x} denoting treatment strategy.}

\item{criteria}{A vector of character names of columns from \code{x} denoting
the criteria to use in the multi criteria decision analysis (MCDA).}

\item{cri}{If \code{TRUE}, credible intervals are computed; otherwise they are not.}

\item{digits}{Number of digits to use.}

\item{rownames}{Row names for returned table.}

\item{colnames}{Column names for returned table.}
}
\value{
A matrix where each row is a criteria and a each column is a treatment
strategy.
}
\description{
Create a performance matrix, which compares mean values of different
criteria across treatment strategies.
}
\seealso{
\code{\link{mcda}}
}
