% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{params_costs_tx}
\alias{params_costs_tx}
\title{Treatment cost parameters}
\format{A list with the following elements:}
\usage{
params_costs_tx
}
\description{
Information on dosage, strength, pricing, and administration costs needed
to estimate costs of treatments sequences.
}
\section{dosage}{

A \code{data.table} containing information on dosage for each
agent used for treatments that can be included in a treatment sequence. The variables
\code{strength1}, \code{strength2}, \code{quantity1}, \code{quantity2}, \code{units_per_day},
and \code{duration_days} can be modified to change annualized costs. 
\describe{
\item{agent_name}{Name of the agent used in the treatment; combination therapies will have
more than one agents.}
\item{dosage}{Amount, number. and frequency of doses over a specified time period.}
\item{dose}{Specified amount of medication taken at one time. By default, doses
based on body surface area (BSA) and weight are based on mean BSA and weight,
respectively.}
\item{unit}{The unit used to compute costs.}
\item{strength1}{The amount of the drug in a single dosage form (e.g., tablet or vial).}
\item{strength2}{If a unit consists of multiple dosage forms, then the amount of the drug
in the dosage form not included in \code{strength1}.}
\item{quantity1}{Quantity of dosage form specified in \code{strength1} in a unit.}
\item{quantity2}{Quantity of dosage form specified in \code{strength2} in a unit.}
\item{units_per_day}{Number of units of the treatment (based on dosage) used per day.}
\item{duration_days}{Number of days to use the treatment. If used until progression, then 
must equal \code{Inf}.}
\item{source}{Source for dosage information.}
}
}

\section{acquisition_costs}{

A \code{data.table} of acquisition costs by \code{agent} and \code{strength}.
Default costs are based on wholesale acquisition costs (WACs). The variable 
\code{acquisition_cost} can be modified to change annualized acquisition costs.
\describe{
\item{agent_name}{Name of the agent}
\item{strength}{The amount of the agent in a given unit of the dosage form.}
\item{acquisition_cost}{The acquisition cost of an \code{agent} for a given \code{strength}.}
\item{source}{Source used for \code{acquisition cost}.}
}
}

\section{discounts}{

\describe{
 \item{agent_name}{Name of the agent.}
 \item{discount_lower}{Lower bound for discount and rebates as a 
 proportion of \code{acquisition_cost} in the \code{acquisition_costs} table.
  Assumed to follow a uniform distribution in the probabilistic sensitivity analysis.}
 \item{discount_upper}{Upper bound for discount and rebates as a 
 proportion of \code{acquisition_cost} in the \code{acquisition_costs} table.
  Assumed to follow a uniform distribution in the probabilistic sensitivity analysis.}
}
}

\section{administration_costs}{

A \code{data.table} of administration costs. The variable \code{costs}
can be modified to change annualized administration costs.
\describe{
\item{agent_name}{Name of the agent.}
\item{administration_cost}{The costs of administering an agent. }
\item{source}{Source used for \code{administration cost}.}
}
}

\section{lookup}{

A lookup \code{data.table} used to match treatments from the \code{\link{treatments}}
table to agents comprising a particular treatment.
\describe{
\item{tx_name}{Name of treatment.}
\item{agent_name1}{Name of first agent used for treatment.}
\item{agent_name2}{Name of second agent used for treatment.}
\item{agent_name3}{Name of third agent used for treatment.}
\item{agent_name4}{Name of fourth agent used for treatment.}
}
}

\examples{
print(params_costs_tx)
}
\keyword{datasets}
