% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mstate_nma_surv}
\alias{mstate_nma_surv}
\alias{mstate_nma_pfs}
\alias{mstate_nma_os}
\title{Progression-free survival and overall survival from network meta-analysis}
\format{A data.table with the following columns:
\describe{
  \item{line}{Line of treatment. Either first or second.}
  \item{mutation}{At 2nd line, equal to 1 if there is a T790M mutation and 
  0 otherwise.}
  \item{model}{The statistical model.} 
  \item{tx_name}{Name of the treatment.}
  \item{month}{Trial month.}
  \item{mean}{Mean PFS/OS from the posterior distribution.}
  \item{median}{Median PFS/OS from the posterior distribution.}
  \item{l95}{Lower limit of 95 percent credible interval from posterior distribution.}
  \item{u95}{Upper limit of the 95 percent credible interval from the posterior distribution.}
}}
\usage{
mstate_nma_pfs

mstate_nma_os
}
\description{
Curves of progression-free survival (PFS) and overall survival (OS) 
estimated using a Bayesian multi-state network meta-analyis (NMA). PFS is 
the duration of time a patient is alive without disease 
progression and OS is the duration of a time a patient is alive.
}
\examples{
head(mstate_nma_pfs)
head(mstate_nma_os)
}
\seealso{
\code{\link{mstate_nma_hazard}},  \code{\link{mstate_nma_hr}}
}
\keyword{datasets}
