% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mstate_nma_hazard}
\alias{mstate_nma_hazard}
\title{Hazard functions from network meta-analysis}
\format{A data.table with the following columns:
\describe{
  \item{line}{Line of treatment. Either first or second.}
  \item{mutation}{At 2nd line, equal to 1 if there is a T790M mutation and 
  0 otherwise.}
  \item{model}{The statistical model.} 
  \item{tx_name}{Name of the treatment.}
  \item{month}{Trial month.}
  \item{transition}{The health state transition.}
  \item{mean}{Mean hazard from the posterior distribution.}
  \item{median}{Median hazard from the posterior distribution.}
  \item{l95}{Lower limit of 95 percent credible interval from posterior distribution.}
  \item{u95}{Upper limit of the 95 percent credible interval from the posterior distribution.}
}}
\usage{
mstate_nma_hazard
}
\description{
Hazard functions for each health state transition
estimated using a Bayesian multi-state network meta-analyis (NMA).
}
\examples{
head(mstate_nma_hazard)
}
\seealso{
\code{\link{mstate_nma_surv}},  \code{\link{mstate_nma_hr}}
}
\keyword{datasets}
