% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mstate_nma_coef}
\alias{mstate_nma_coef}
\title{Coefficients from network meta-analysis}
\format{A data.table with the following columns:
\describe{
  \item{line}{Line of treatment. Either first or second.}
  \item{model}{The statistical model.} 
  \item{tx_name}{Name of the treatment.}
  \item{transition}{The health state transition.}
  \item{coef}{Coefficient as outlined mathematically in the 
                  PDF model documentation.}
  \item{q0.025}{2.5th percentile of the posterior distribution.}
  \item{q0.25}{25th percentile of the posterior distribution.}
  \item{q0.5}{50th percentile of the posterior distribution.}
  \item{q0.75}{75th percentile of the posterior distribution.}
  \item{q0.90}{90th percentile of the posterior distribution.}
}}
\usage{
mstate_nma_coef
}
\description{
Coefficients for first line treatments relative to gefitinib
estimated using a Bayesian multi-state network meta-analyis (NMA).
}
\examples{
print(mstate_nma_coef)
}
\seealso{
\code{\link{mstate_ma_coef}}
}
\keyword{datasets}
