% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mstate_ma_coef}
\alias{mstate_ma_coef}
\title{Coefficients from meta-analyses}
\format{A data.table with the following columns:
\describe{
  \item{line}{Line of treatment. Either first or second.}
  \item{mutation}{At 2nd line, equal to 1 if there is a T790M mutation and 
  0 otherwise.}
  \item{model}{The statistical model.} 
  \item{tx_name}{Name of the treatment.}
  \item{transition}{The health state transition.}
  \item{coef}{Coefficient as outlined mathematically in the 
                  PDF model documentation.}
  \item{q0.025}{2.5th percentile of the posterior distribution.}
  \item{q0.25}{25th percentile of the posterior distribution.}
  \item{q0.5}{50th percentile of the posterior distribution.}
  \item{q0.75}{75th percentile of the posterior distribution.}
  \item{q0.90}{90th percentile of the posterior distribution.}
}}
\usage{
mstate_ma_coef
}
\description{
Coefficients for first and second line absolute effects estimated using
Bayesian meta-analyes (MAs).
}
\examples{
print(mstate_ma_coef)
}
\seealso{
\code{\link{mstate_nma_coef}}
}
\keyword{datasets}
